# coding: utf-8

from operator import attrgetter

from django.db.models import F
from django_filters.rest_framework import (
    BooleanFilter,
    DateTimeFromToRangeFilter,
    FilterSet,
)
from rest_framework.filters import OrderingFilter

from procu.api import models


class SavingOrderingFilter(OrderingFilter):
    def filter_queryset(self, request, queryset, view):
        ordering = list(self.get_ordering(request, queryset, view))

        if ordering:
            final_ordering = []

            for field in ordering:
                if field.endswith('absolute') or field.endswith('relative'):
                    func = attrgetter('desc' if field[0] == '-' else 'asc')
                    field = func(F(field.lstrip('-')))(nulls_last=True)

                final_ordering.append(field)

            return queryset.order_by(*final_ordering)

        return queryset


class EnquiryFilterSet(FilterSet):
    date = DateTimeFromToRangeFilter(field_name='created_at')
    saving = BooleanFilter(
        field_name='saving__saving', lookup_expr='isnull', exclude=True
    )

    class Meta:
        model = models.Enquiry
        fields = ('date', 'saving')
