# coding: utf-8

from procu.api import enums, models, utils
from procu.api.common.fields import EnumField
from procu.rest import serializers


class EnquirySerializer(serializers.ModelSerializer):
    relative = serializers.DecimalField(decimal_places=1, max_digits=14)
    absolute = serializers.SerializerMethodField()
    note = EnumField(enum_class=enums.SavingNote, name_only=True)

    currency = serializers.SerializerMethodField()

    class Meta:
        model = models.Enquiry
        fields = (
            'id',
            'subject',
            'created_at',
            'updated_at',
            'absolute',
            'currency',
            'relative',
            'note',
        )

    @staticmethod
    def get_currency(instance):
        if instance.currency:
            return {
                'prefix': instance.currency_prefix,
                'suffix': instance.currency_suffix,
            }

    @staticmethod
    def get_absolute(instance):
        if instance.absolute is not None:
            return utils.format_price(instance.absolute)
