# coding: utf-8

from procu.rest import serializers


class QueryParamsSerializer(serializers.Serializer):
    vat_id = serializers.IntegerField(required=True)


class Risk(serializers.Serializer):
    short_name = serializers.CharField(required=True)
    full_name = serializers.CharField(required=True)
    indicator = serializers.ChoiceField(choices=('low', 'moderate', 'high'))
    score = serializers.IntegerField(required=False)
    description = serializers.CharField(required=True)


class Factor(serializers.Serializer):
    name = serializers.CharField(required=True)
    info = serializers.JSONField(required=True)


class Report(serializers.Serializer):
    risks = serializers.ListSerializer(child=Risk(), allow_empty=True)
    factors = serializers.ListSerializer(child=Factor(), allow_empty=True)
