# coding: utf-8

from celery import shared_task
from celery.utils.log import get_task_logger
from django.utils import timezone

from procu.api import models
from procu.utils.lock import locked


@shared_task
@locked(name='update_supplier_risks')
def update_supplier_risks(supplier_id, update=False):
    logger = get_task_logger(__name__)

    from procu.api.spark.utils import get_risks_summary
    from procu.api.enums import RISK

    supplier = models.Supplier.objects.only('vat_id').get(id=supplier_id)
    vat_id = supplier.vat_id

    try:
        summary = get_risks_summary(vat_id, update)

        supplier.risk_data = summary
        supplier.risk = RISK.get_by_key(summary['risks'][0]['indicator'])
        supplier.risk_updated_at = timezone.now()

        supplier.save(update_fields=('risk_data', 'risk', 'risk_updated_at'))
        logger.info('Supplier #%d: risks are updated', supplier_id)

    except Exception:
        logger.exception('Supplier #%d: failed to update risks', supplier_id)

        supplier.risk = RISK.UNKNOWN
        supplier.risk_data = {}
        supplier.save(update_fields=('risk', 'risk_data'))
