# coding: utf-8

from django.conf import settings

import boto3.session
from storages.backends.s3boto3 import S3Boto3Storage as _S3Boto3Storage


class S3Boto3Storage(_S3Boto3Storage):
    @property
    def connection(self):
        if self._connection is None:
            session = boto3.session.Session()

            if settings.AWS_S3_USE_INTERNAL_CERT:
                cert_kwargs = {'verify': settings.INTERNAL_ROOT_CA}
            else:
                cert_kwargs = {}

            self._connection = session.resource(
                self.connection_service_name,
                aws_access_key_id=self.access_key,
                aws_secret_access_key=self.secret_key,
                region_name=self.region_name,
                use_ssl=self.use_ssl,
                endpoint_url=self.endpoint_url,
                config=self.config,
                **cert_kwargs,
            )
        return self._connection
