# coding: utf-8

from rest_framework.filters import BaseFilterBackend

from procu.api.utils import strtobool
from procu.rest.filters import BaseListFilter


class SuppliersByTagsFilter(BaseListFilter):
    query_param = 'tags'
    field = 'tags'


class HideFilter(BaseListFilter):
    """
    Return empty queryset when filtering by `id'.
    It is used for mixed suggests (such as Suppliers + Tags) to hide tags.
    """

    query_param = 'id'
    field = 'dummy'

    def apply_filter(self, queryset, condition):
        if condition:
            return queryset.none()
        else:
            return queryset


class OEBSLegalEntitiesOnly(BaseFilterBackend):
    def filter_queryset(self, request, queryset, view):

        if strtobool(request.GET.get('oebs_only')):
            return queryset.filter(oracle_legal_entity__isnull=False)

        return queryset
