# coding: utf-8

from itertools import chain
from typing import Union

from rest_framework.generics import GenericAPIView


class SuggestMixin(object):
    @staticmethod
    def finalize_queryset(queryset):
        return queryset.distinct(*queryset.query.order_by)

    def make_response_data(self, objects):

        if 'none' in self.request.GET.getlist('id'):
            empty = {
                'id': 'none',
                'title': '—',
                'is_deleted': False,
                'type': 'default',
            }
            return chain((empty,), objects)

        return objects

    def get(
        self: Union[GenericAPIView, 'SuggestMixin'], request, *args, **kwargs
    ):
        qs = self.filter_queryset(self.get_queryset())
        qs = self.finalize_queryset(qs)
        page = self.paginate_queryset(qs)
        output = self.make_response_data(page)
        return self.get_paginated_response(output)
