# coding: utf-8

from django_filters import FilterSet, NumberFilter

from procu.api import models


class ProgramFilter(FilterSet):
    legal_entity = NumberFilter(method='filter_by_legal_entity')
    project = NumberFilter(method='filter_by_project')
    task = NumberFilter(method='filter_by_task')

    class Meta:
        model = models.OracleProgram
        fields = ('legal_entity', 'project', 'task')

    @staticmethod
    def filter_by_legal_entity(qs, name, value):
        return qs.filter(projects__company__legal_entity=value)

    @staticmethod
    def filter_by_project(qs, name, value):
        return qs.filter(projects=value)

    @staticmethod
    def filter_by_task(qs, name, value):
        return qs.filter(projects__tasks=value)


class ProjectFilter(FilterSet):
    legal_entity = NumberFilter(method='filter_by_legal_entity')
    program = NumberFilter(method='filter_by_program')
    task = NumberFilter(method='filter_by_task')

    class Meta:
        model = models.OracleProject
        fields = ('legal_entity', 'program', 'task')

    @staticmethod
    def filter_by_legal_entity(qs, name, value):
        return qs.filter(company__legal_entity=value)

    @staticmethod
    def filter_by_program(qs, name, value):
        return qs.filter(program_id=value)

    @staticmethod
    def filter_by_task(qs, name, value):
        return qs.filter(tasks=value)


class TaskFilter(FilterSet):
    legal_entity = NumberFilter(method='filter_by_legal_entity')
    program = NumberFilter(method='filter_by_program')
    project = NumberFilter(method='filter_by_project')

    class Meta:
        model = models.OracleTask
        fields = ('legal_entity', 'program', 'project')

    @staticmethod
    def filter_by_legal_entity(qs, name, value):
        return qs.filter(project__company__legal_entity=value)

    @staticmethod
    def filter_by_program(qs, name, value):
        return qs.filter(project__program_id=value)

    @staticmethod
    def filter_by_project(qs, name, value):
        return qs.filter(project_id=value)
