# coding: utf-8

from django.db.transaction import non_atomic_requests as _n
from django.urls import re_path

from .views import *

urlpatterns = [
    re_path(r'^/cfos/?$', _n(CFOView.as_view())),
    re_path(r'^/programs/?$', _n(ProgramView.as_view())),
    re_path(r'^/projects/?$', _n(ProjectView.as_view())),
    re_path(r'^/tasks/?$', _n(TaskView.as_view())),
    re_path(r'^/mvps/?$', _n(MVPView.as_view())),
    re_path(r'^/services/?$', _n(ServiceView.as_view())),
    re_path(r'^/product_lines/?$', _n(ProductLineView.as_view())),
    re_path(r'^/purchase_groups/?$', _n(PurchaseGroupView.as_view())),
    re_path(r'^/companies/?$', _n(CompanyView.as_view())),
    re_path(r'^/currencies/?$', _n(CurrencyView.as_view())),
    re_path(r'^/suppliers/?$', _n(SupplierView.as_view())),
    re_path(r'^/budget_lines/?$', _n(BudgetLineView.as_view())),
    re_path(r'^/systems/?$', _n(SystemView.as_view())),
    re_path(r'^/subsystems/?$', _n(SubSystemView.as_view())),
]
