# coding: utf-8

from django.conf import settings

from procu.api.enums import LINK
from procu.rest import serializers

TRACKER_URL = settings.LINK_URLS[LINK.TRACKER]


class TicketSerializer(serializers.Serializer):
    type = serializers.SerializerMethodField()
    id = serializers.CharField(source='key')
    title = serializers.CharField(source='key')
    subtitle = serializers.CharField(source='summary')
    url = serializers.SerializerMethodField()

    @staticmethod
    def get_type(instance):
        return 'default'

    @staticmethod
    def get_url(instance):
        return TRACKER_URL.format(key=instance.key)
