# coding: utf-8

from django.utils.translation import gettext_lazy as _

from procu.api import models
from procu.api.common.fields import EnumField
from procu.api.enums import RISK
from procu.api.user.serializers import UserBrief
from procu.rest.fields import PKPrettyField


class AgentField(PKPrettyField):
    default_error_messages = {
        'invalid_user': _('CONTACT_FIELD::INVALID_USER{pk}')
    }

    def __init__(self, **kwargs):
        kwargs['queryset'] = models.User.objects.filter(
            is_deleted=False, is_staff=False
        )
        kwargs['serializer'] = UserBrief
        super().__init__(**kwargs)

    def to_internal_value(self, pk):
        try:
            return self.queryset.get(pk=pk)

        except models.User.DoesNotExist:
            self.fail('invalid_user', pk=pk)


class RiskField(EnumField):
    enum_class = RISK

    def __init__(self, **kwargs):
        kwargs['read_only'] = True
        super().__init__(**kwargs)
