# coding: utf-8

from django_filters.rest_framework import BooleanFilter, FilterSet

from procu.api import models
from procu.rest.filters import BaseListFilter


class SuppliersByTagsFilter(BaseListFilter):
    query_param = 'tags'
    field = 'tags'


class SupplierFilter(FilterSet):
    has_contract = BooleanFilter()
    is_cold = BooleanFilter()
    can_pay_by_card = BooleanFilter(method='filter_can_pay_by_card')

    class Meta:
        model = models.Supplier
        fields = ('is_cold', 'has_contract', 'can_pay_by_card')

    @staticmethod
    def filter_can_pay_by_card(qs, name, value):
        if value:
            return qs.filter(can_pay_by_card=value)
        return qs
