# coding: utf-8

from django.conf.urls import include, url

from .views import *


def _include(path):
    return include('procu.api.supplier.%s' % path)


urlpatterns = [
    url(r'^/?$', SupplierList.as_view()),
    url(r'^/cold/?$', SupplierCreateCold.as_view()),
    url(
        r'^/(?P<supplier_id>[0-9]+)',
        include(
            [
                url(r'^/warnings', _include('warning.urls')),
                url(r'^/warmup/?$', SupplierWarmUp.as_view()),
                url(r'^/risks/?$', SupplierRetrieveUpdateRisks.as_view()),
                url(r'^/?$', SupplierEntry.as_view()),
            ]
        ),
    ),
]
