# coding: utf-8

from django.utils.translation import gettext_lazy as _
from rest_framework.exceptions import ValidationError

from procu.api.utils.inn import inn_checksum


def validate_vat_id(value):
    if not value.isdigit():
        raise ValidationError(_('SUPPLIER::ERROR_VAT_ID_NUMERICAL'))

    if len(value) != 10 and len(value) != 12:
        raise ValidationError(_('SUPPLIER::ERROR_VAT_ID_LENGTH'))

    if not inn_checksum(value):
        raise ValidationError(_('SUPPLIER::ERROR_VAT_ID_CHECKSUM'))
