# coding: utf-8

from procu.api import models
from procu.api.common.fields import UserBrief
from procu.rest import serializers


class Create(serializers.ModelSerializer):
    class Meta:
        model = models.SupplierWarning
        fields = ('id', 'message')


class RetrieveUpdate(serializers.ModelSerializer):

    author = UserBrief(read_only=True)

    class Meta:
        model = models.SupplierWarning
        fields = ('id', 'message', 'author', 'created_at', 'updated_at')


class List(serializers.ModelSerializer):

    author = UserBrief()
    can_edit = serializers.SerializerMethodField()

    class Meta:
        model = models.SupplierWarning
        fields = (
            'id',
            'message',
            'author',
            'created_at',
            'updated_at',
            'can_edit',
            'is_deleted',
        )

    def get_can_edit(self, instance):
        user = self.context['request'].user
        return not self.context['is_readonly'] and instance.author == user
