# coding: utf-8

from django.utils.translation import gettext_lazy as _
from rest_framework import validators

from procu.api import models
from procu.rest.fields import PKPrettyField
from procu.rest import serializers


class SupplierBrief(serializers.ModelSerializer):
    class Meta:
        model = models.Supplier
        fields = ('id', 'title', 'legal_name', 'is_cold', 'is_deleted')


class SupplierTagBriefSerializer(serializers.ModelSerializer):
    label = serializers.CharField(
        validators=[
            validators.UniqueValidator(
                queryset=models.SupplierTag.objects.all(),
                message=_('SUPPLIER_TAGS::ERROR_ALREADY_EXISTS'),
                lookup='iexact',
            )
        ],
        max_length=127,
    )

    class Meta:
        model = models.SupplierTag
        fields = ('id', 'label')


class SupplierTagSerializer(SupplierTagBriefSerializer):

    suppliers = PKPrettyField(
        queryset=models.Supplier.objects.filter(is_deleted=False),
        serializer=SupplierBrief,
        many=True,
        required=False,
        label=_('SUPPLIER_TAGS::SUPPLIERS'),
    )

    @staticmethod
    def validate_label(value):
        return value.lower()

    class Meta:
        model = models.SupplierTag
        fields = ('id', 'label', 'comment', 'suppliers', 'is_hidden')
