# coding: utf-8

from urllib.parse import urljoin

from django import template
from django.conf import settings
from django.core.exceptions import ImproperlyConfigured
from django.utils.encoding import force_text
from django.utils.safestring import mark_safe

register = template.Library()


@register.simple_tag
def base_url(env):

    if env == 'internal':
        return settings.FRONT_INTERNAL_PREFIX

    elif env == 'external':
        return settings.FRONT_EXTERNAL_PREFIX

    else:
        raise ImproperlyConfigured(
            "Environment must be either `internal' or `external'"
        )


@register.filter
def attachment_url(attachment, env):

    if env == 'internal':
        prefix = settings.BACK_INTERNAL_PREFIX

    elif env == 'external':
        prefix = settings.BACK_EXTERNAL_PREFIX

    else:
        raise ImproperlyConfigured(
            "Environment must be either `internal' or `external'"
        )

    return urljoin(
        urljoin(prefix, settings.ATTACHMENTS_PREFIX),
        force_text(attachment['id']),
    )


@register.filter()
def nbsp(value):
    return mark_safe("&nbsp;".join(value.split(' ')))


@register.filter()
def uauth(value):
    return '%s=%s' % (settings.URL_PARAM_REF, value)
