# coding: utf-8

import re

from django.db.models import Q
from procu.rest.filters import BaseFilterBackend

ID_REGEX = re.compile(r'(YP-?)?(\d+)', flags=re.I)


class YPFilter(BaseFilterBackend):
    query_param = None
    field = None

    def filter_queryset(self, request, queryset, view):

        query_list_raw = request.GET.getlist('id')

        query_list = filter(None, map(ID_REGEX.match, query_list_raw))
        ids = [t.group(2) for t in query_list]

        if query_list_raw and not ids:
            return queryset.none()

        condition = Q(id__in=ids) if ids else Q()

        return queryset.filter(condition)
