# coding: utf-8

from procu.api import models
from procu.api.enquiry.fields import EStatusField
from procu.rest import serializers


class EnquirySerializer(serializers.ModelSerializer):
    id = serializers.CharField(source='key')
    manager = serializers.SerializerMethodField()
    status = EStatusField()
    deadline_at = serializers.DateTimeField(allow_null=True)

    class Meta:
        model = models.Enquiry
        fields = (
            'id',
            'subject',
            'deadline_at',
            'updated_at',
            'manager',
            'status',
        )

    @staticmethod
    def get_manager(instance):
        try:
            return instance.manager.username

        except AttributeError:
            return None


class Link(serializers.Serializer):

    ticket = serializers.CharField()


class IssueSerializer(serializers.Serializer):
    key = serializers.CharField()


class EventSerializer(serializers.Serializer):
    id = serializers.CharField()
    type = serializers.CharField()


class HookSerializer(serializers.Serializer):
    event = EventSerializer()
    issue = IssueSerializer()
