# coding: utf-8

from django.utils.translation import gettext_lazy as _
from rest_framework.validators import UniqueValidator

from procu.api import models
from procu.rest import serializers


class UnitSerializer(serializers.ModelSerializer):

    name = serializers.CharField(
        validators=[
            UniqueValidator(
                queryset=models.Unit.objects.filter(is_deleted=False),
                message=_('UNIT::ERROR_UNIT_ALREADY_EXISTS'),
                lookup='iexact',
            )
        ],
        max_length=255,
        label=_('MODEL_UNIT::NAME'),
        style={'x-hint': _('UNIT::NAME_HINT')},
    )
    shortname = serializers.CharField(
        max_length=30, label=_('MODEL_UNIT::SHORTNAME')
    )

    @staticmethod
    def validate_name(value):
        return value.lower()

    @staticmethod
    def validate_shortname(value):
        return value.lower()

    class Meta:
        model = models.Unit
        fields = ('id', 'shortname', 'name')
