# coding: utf-8

from rest_framework.filters import OrderingFilter

from procu.api import models
from procu.rest import generics
from procu.rest.filters import IncludeFilter, SearchFilter
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import EntryPermission, ListPermission
from .serializers import UnitSerializer


class UnitListCreate(generics.ListCreateAPIView):
    queryset = models.Unit.objects.filter(is_deleted=False)
    serializer_class = UnitSerializer
    pagination_class = PageNumberPagination
    permission_classes = (ListPermission,)
    filter_backends = (IncludeFilter, SearchFilter, OrderingFilter)

    search_fields = ('name', 'shortname')

    ordering_fields = ('id', 'name')
    ordering = ('name', 'id')


class UnitRetrieveUpdateDestroy(generics.RetrieveUpdateDestroyAPIView):
    queryset = models.Unit.objects.all()
    serializer_class = UnitSerializer
    permission_classes = (EntryPermission,)
    lookup_url_kwarg = 'unit_id'
