# coding: utf-8

from django.contrib.auth.tokens import default_token_generator

from rest_framework.permissions import BasePermission


class RestorePermission(BasePermission):
    def has_object_permission(self, request, view, obj):
        token = view.query_params['token']
        return default_token_generator.check_token(obj, token)
