# coding: utf-8

from django.utils.translation import gettext_lazy as _
from rest_framework.exceptions import ValidationError

from procu.api import models
from procu.rest import serializers


class GetRestoreTokenSerializer(serializers.ModelSerializer):

    email = serializers.EmailField(required=True, max_length=127)

    class Meta:
        model = models.User
        fields = ('email',)


class RestoreSerializer(serializers.Serializer):

    password = serializers.CharField(
        allow_blank=False,
        max_length=255,
        required=True,
        label=_('RESTORE_PASSWORD::PASSWORD'),
    )
    password_confirmation = serializers.CharField(
        allow_blank=False,
        max_length=255,
        required=True,
        label=_('RESTORE_PASSWORD::PASSWORD_CONFIRMATION'),
    )

    def validate(self, data):

        if data['password'] != data['password_confirmation']:
            raise ValidationError(
                {'password_confirmation': _('RESTORE_PASSWORD::NO_MATCH')}
            )

        return data


class RestoreParams(serializers.Serializer):

    user = serializers.IntegerField(required=True, min_value=1)
    token = serializers.CharField(required=True)
