# coding: utf-8

from django.utils.translation import gettext_lazy as _

from procu.api import models
from procu.rest import serializers


EXTRA_KWARGS = {
    'is_subscribed_created': {
        'label': _('USER_SETTINGS::IS_SUBSCRIBED_CREATED')
    },
    'sort_quotes_by_updated': {
        'label': _('USER_SETTINGS::SORT_QUOTES_BY_UPDATED')
    },
    'signature': {'label': _('USER_SETTINGS::SIGNATURE')},
}


class Retrieve(serializers.ModelSerializer):

    signature = serializers.CharField(
        label=_('USER_SETTINGS::SIGNATURE'), source='full_signature'
    )

    class Meta:
        model = models.User
        fields = (
            'is_subscribed_created',
            'sort_quotes_by_updated',
            'signature',
        )
        extra_kwargs = EXTRA_KWARGS.copy()


class Update(serializers.ModelSerializer):
    class Meta:
        model = models.User
        fields = (
            'is_subscribed_created',
            'sort_quotes_by_updated',
            'signature',
        )
        extra_kwargs = EXTRA_KWARGS.copy()
