# coding: utf-8

from procu.rest import generics, permissions
from . import serializers


class SettingsView(generics.RetrieveUpdateAPIView):
    permission_classes = (permissions.StaffOnly,)

    def get_serializer_class(self):
        if self.request.method == 'PATCH':
            return serializers.Update
        else:
            return serializers.Retrieve

    def get_object(self):
        return self.request.user
