# coding: utf-8

from django.urls import include, re_path
from django_replicated.decorators import use_master

from .views import *


def _include(path):
    return include('procu.api.user.%s' % path)


urlpatterns = [
    re_path(r'^/current/?$', CurrentUser.as_view()),
    re_path(r'^/csrf/?$', CSRF.as_view()),
    re_path(r'^/change_password/?$', ExternalChangePassword.as_view()),
    re_path(r'^/restore', _include('restore.urls')),
    re_path(r'^/settings', _include('settings.urls')),
    re_path(r'^/quicklogin/?$', QuickLogin.as_view()),
    re_path(r'^/yalogin/?$', InternalLogin.as_view()),
    re_path(r'^/login/?$', ExternalLogin.as_view()),
    re_path(r'^/logout/?$', ExternalLogout.as_view()),
]
