# coding: utf-8


def hex_to_rgb(code):
    """
    "#FFFFFF" -> [255,255,255]
    """

    # Pass 16 to the integer function for change of base
    return [int(code[i : i + 2], 16) for i in range(1, 6, 2)]


def rgb_to_hex(rgb):
    """
    [255,255,255] -> "#FFFFFF"
    """

    # Components need to be integers for hex to make sense
    rgb = [int(x) for x in rgb]
    return "#" + "".join(
        ["0{0:x}".format(v) if v < 16 else "{0:x}".format(v) for v in rgb]
    )


def colour_gradient(start_hex, *, finish_hex="#FFFFFF", n=10):
    """
    returns a gradient list of (n) colors between
    two hex colors. start_hex and finish_hex
    should be the full six-digit color string,
    inlcuding the number sign ("#FFFFFF")
    """

    # Starting and ending colors in RGB form
    s = hex_to_rgb(start_hex)
    f = hex_to_rgb(finish_hex)

    # Initilize a list of the output colors with the starting color
    rgb_list = [s]

    # Calcuate a color at each evenly spaced value of t from 1 to n
    for t in range(1, n):

        # Interpolate RGB vector for color at the current value of t
        curr_vector = [
            int(s[j] + (float(t) / (n - 1)) * (f[j] - s[j])) for j in range(3)
        ]

        # Add it to our list of output colors
        rgb_list.append(curr_vector)

    return [rgb_to_hex(x) for x in rgb_list]
