# coding: utf-8

from operator import mul

MAGIC_12_N1 = (3, 7, 2, 4, 10, 3, 5, 9, 4, 6, 8)
MAGIC_12_N2 = (7, 2, 4, 10, 3, 5, 9, 4, 6, 8)
MAGIC_10 = (2, 4, 10, 3, 5, 9, 4, 6, 8)


def inn_checksum(value: str) -> bool:
    digits = tuple(map(int, value))

    if len(value) == 12:
        n1 = (sum(map(mul, MAGIC_12_N1, digits)) % 11) % 10
        n2 = (sum(map(mul, MAGIC_12_N2, digits)) % 11) % 10
        return n2 == digits[-2] and n1 == digits[-1]

    elif len(value) == 10:
        n = (sum(map(mul, MAGIC_10, digits)) % 11) % 10
        return n == digits[-1]

    return False
