# coding: utf-8
from collections import OrderedDict

from django.http import JsonResponse
from rest_framework.utils.encoders import JSONEncoder


class ErrorResponse(JsonResponse):
    def __init__(self, data=None, msg=None, *args, **kwargs):
        json_data = OrderedDict()

        if msg:
            json_data['detail'] = msg

        json_data.update(data or {})

        encoder = kwargs.pop('encoder', JSONEncoder)

        dumps_params = kwargs.pop('json_dumps_params', {})
        dumps_params['ensure_ascii'] = False

        super().__init__(
            json_data,
            *args,
            encoder=encoder,
            json_dumps_params=dumps_params,
            **kwargs,
        )
