# coding: utf-8

from django.core.cache import cache

from procu.api.utils import maybe_fetch_users


def get_phone(username: str) -> str:
    def _get_phone():

        users = maybe_fetch_users([username], ['phones.number'])

        try:
            return users[0]['phones'][0]['number']

        except Exception as exc:
            raise ValueError(
                f'could not fetch a phone number of `{username}`'
            ) from exc

    return cache.get_or_set(('phone', username), _get_phone, timeout=3600 * 24)
