# coding: utf-8

import re

RE_TERMS = re.compile(r'(?:(\d+%?)_)?(adv|net)(?:_(\d+%?))?', flags=re.I)

TYPES = {'adv': 'pre', 'net': 'post'}


def parse_terms(comment: str) -> dict:

    terms = {'comment': comment}

    tokens = RE_TERMS.findall(comment)

    percent_total = 0

    for num1, pay_type, num2 in tokens:
        pay_type = pay_type.lower()

        if pay_type not in TYPES:
            continue

        if num1 == num2 == '':
            continue

        # Count percent sings occurrences
        count_pc = sum(map(lambda x: '%' in x, (num1, num2)))

        if count_pc == 0 and (bool(num1) + bool(num2) == 1):
            if not num1:
                num1 = '100%'
            else:
                num2 = '100%'

        elif not (num1 and num2) or count_pc != 1:
            continue

        percent, days = sorted((num1, num2), key=lambda x: '%' not in x)
        percent, days = int(percent[:-1]), int(days)

        terms[TYPES[pay_type]] = [percent, days]
        percent_total += percent

    if percent_total != 100:
        terms.pop('post', None)
        terms.pop('pre', None)

    return terms
