# coding: utf-8
from hashlib import md5

from django.conf import settings
from startrek_client import Startrek

from procu.utils.tvm import get_service_ticket, get_user_ticket


def get_tracker_client(*, base_url=None, request=None):

    if request:
        auth_params = {
            'service_ticket': get_service_ticket(settings.TVM_TRACKER_CLIENT_ID),
            'user_ticket': get_user_ticket(request),
        }
    else:
        auth_params = {'token': settings.INTRANET_OAUTH_TOKEN}

    return Startrek(
        useragent=settings.STARTREK_API_USER_AGENT,
        base_url=base_url or settings.STARTREK_API_URL,
        timeout=settings.STARTREK_API_TIMEOUT,
        retries=settings.STARTREK_API_RETRIES,
        **auth_params,
    )


def get_unique_id(kwargs):
    s = f'{kwargs["queue"]}' f'|{kwargs["summary"]}' f'|{kwargs["description"]}'
    return md5(s.encode()).hexdigest()
