# coding: utf-8

import re
from urllib.parse import urlparse

from rest_framework import response

from procu.api import models
from procu.api.enums import ES
from procu.rest import generics
from procu.rest.permissions import StaffOnly
from . import serializers

PATH_RE = re.compile(
    r'^/(?:(?P<type>YP)(?P<id>\d+))/?(?:procurement|comments)?$', flags=re.I
)

HOSTS = ('procu.yandex-team.ru', 'procu.test.yandex-team.ru')


class MagicLinkView(generics.GenericAPIView):
    permission_classes = (StaffOnly,)

    def post(self, request):

        data = serializers.InputSerializer(data=request.data)
        data.is_valid(raise_exception=True)
        urls = data.validated_data['urls']

        ids = []

        for url in urls:
            parts = urlparse(url)
            match = PATH_RE.match(parts.path)

            if parts.netloc in HOSTS and match:
                ids.append(int(match.group('id')))
            else:
                ids.append(None)

        # ----------------------------------------------------------------------

        qs = (
            models.Enquiry.objects.permitted(self.request.user)
            .select_related('manager')
            .values('id', 'key', 'manager__username', 'subject', 'status')
            .filter(id__in=filter(None, ids))
        )
        enquiries = {e['id']: e for e in qs}

        output = []

        for id in ids:
            if id is None:
                output.append({})

            else:
                try:
                    e = enquiries[id]
                    output.append(
                        {
                            'id': e['id'],
                            'key': e['key'],
                            'title': e['subject'],
                            'username': e['manager__username'],
                            'status': {
                                'key': ES.keys[e['status']],
                                'name': ES.i18n[e['status']],
                            },
                        }
                    )

                except KeyError:
                    output.append({'id': id, 'key': 'YP%d' % id})

        return response.Response(output)
