# coding: utf-8

from django.contrib.auth import get_user_model
from rest_framework import authentication

User = get_user_model()


class MixedAuthentication(authentication.SessionAuthentication):
    oauth_scopes = ('procu:api',)

    def authenticate(self, request):

        user = getattr(request._request, 'user', None)
        if not user.is_authenticated:
            return None

        yauser = getattr(request._request, 'yauser', None)
        if not yauser or yauser.authenticated_by.mechanism_name == 'cookie':
            self.enforce_csrf(request)

        if self.check_scopes(request):
            return user, None

    def check_scopes(self, request):
        yauser = getattr(request._request, 'yauser', None)

        if yauser is None:
            return True

        if yauser.authenticated_by.mechanism_name == 'oauth':
            return set(self.oauth_scopes) <= yauser.scopes

        return True

    def authenticate_header(self, request):
        return 'Mixed realm="procu"'


class MixedAuthenticationIgnoreScopes(MixedAuthentication):
    oauth_scopes = ()
