# coding: utf-8

from collections import OrderedDict


class CreateMetaMixin(object):
    def meta_post(self, components):

        info = OrderedDict()

        if 'in' in components:

            serializer = self.get_serializer()
            write_schema = self.get_schema(write=True)

            write_schema['required'] = [
                field_name
                for field_name, field in serializer.fields.items()
                if getattr(field, 'required', False)
            ]

            parameters = [
                OrderedDict(
                    [
                        ('in', 'body'),
                        ('name', 'body'),
                        ('required', True),
                        ('schema', write_schema),
                    ]
                )
            ]

            info['parameters'] = parameters

        if 'out' in components:
            response = self.get_schema(write=False)
            info['responses'] = {'default': response}

        return info


class ReplaceMetaMixin(object):
    def meta_put(self, components):

        info = OrderedDict()

        if 'in' in components:

            serializer = self.get_serializer()
            write_schema = self.get_schema(write=True)

            write_schema['required'] = [
                field_name
                for field_name, field in serializer.fields.items()
                if getattr(field, 'required', False)
            ]

            parameters = [
                OrderedDict(
                    [
                        ('in', 'body'),
                        ('name', 'body'),
                        ('required', True),
                        (
                            'schema',
                            OrderedDict(
                                [('type', 'array'), ('items', write_schema)]
                            ),
                        ),
                    ]
                )
            ]

            info['parameters'] = parameters

        if 'out' in components:
            read_schema = self.get_schema(write=False)

            response = OrderedDict([('type', 'array'), ('items', read_schema)])
            info['responses'] = {'default': response}

        return info


class ListMetaMixin(object):
    def meta_get(self, components):

        info = OrderedDict()

        if 'in' in components:
            info['parameters'] = []

        if 'out' in components:
            schema = self.get_schema(write=False)

            response = OrderedDict([('type', 'array'), ('items', schema)])

            info['responses'] = OrderedDict([('default', response)])

        return info


class RetrieveMetaMixin(object):
    def meta_get(self, components):

        info = OrderedDict()

        if 'in' in components:
            info['parameters'] = []

        if 'out' in components:
            info['responses'] = OrderedDict(
                [('default', self.get_schema(write=False))]
            )

        return info


class UpdateMetaMixin(object):
    def meta_patch(self, components):

        info = OrderedDict()

        if 'in' in components:

            obj = self.object
            write_schema = self.get_serializer(obj).meta(write=True).asdict()

            write_schema['required'] = []

            parameters = [
                OrderedDict(
                    [
                        ('in', 'body'),
                        ('name', 'body'),
                        ('required', False),
                        ('schema', write_schema),
                    ]
                )
            ]

            info['parameters'] = parameters

        if 'out' in components:
            response = self.get_schema(write=False)

            info['responses'] = OrderedDict([('default', response)])

        return info


class DestroyMetaMixin(object):
    @staticmethod
    def meta_delete(components):
        info = OrderedDict()

        if 'in' in components:
            info['parameters'] = []

        if 'out' in components:
            info['responses'] = {}

        return info
