# coding: utf-8

import decimal

from rest_framework import renderers
from rest_framework.utils import encoders


class JSONEncoder(encoders.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, decimal.Decimal):
            return str(obj)
        return super().default(obj)


class JSONRenderer(renderers.JSONRenderer):
    charset = 'utf-8'
    encoder_class = JSONEncoder
