# coding: utf-8

from . import IS_DEVELOPMENT, IS_PRODUCTION, IS_TESTING, ds

INTERNAL_ROOT_CA = '/etc/ssl/certs/YandexInternalRootCA.pem'

# ------------------------------------------------------------------------------

if IS_PRODUCTION:
    ROBOT_LOGIN = 'robot-procu'
else:
    ROBOT_LOGIN = 'robot-procu-test'

# ------------------------------------------------------------------------------
# OAuth

# INTRANET_OAUTH_TOKEN = ds.oauth_tokens.get(ROBOT_LOGIN)

INTRANET_OAUTH_TOKEN = ds.__getattr__(ROBOT_LOGIN)

# ------------------------------------------------------------------------------
# Tracker

STARTREK_API_URL = 'https://st-api.yandex-team.ru'
STARTREK_API_USER_AGENT = 'procu'
STARTREK_API_PAGE_LIMIT = 40
STARTREK_API_TIMEOUT = 3.08
STARTREK_API_RETRIES = 2

if not IS_PRODUCTION:
    STARTREK_API_URL = 'https://st-api.test.yandex-team.ru'

STARTREK_LINK_ORIGIN = 'ru.yandex.procu'

# ------------------------------------------------------------------------------
# Wiki-Formatter

if IS_TESTING:
    WF_HOST = 'wf.test.yandex-team.ru'

# ------------------------------------------------------------------------------
# Queues

if IS_TESTING or IS_DEVELOPMENT:
    BUY_QUEUE = 'TESTBUY'
    DCBUY_QUEUE = 'TESTBUY'
    ACC_QUEUE = 'TESTACC'
    SCS_QUEUE = 'TESTSCS'
    LDM_QUEUE = 'TESTLOGIC'
    WAREHOUSE_QUEUE = 'TESTLOGIC'
    WAREHOUSE_LOC_FIELD = 'logisticsLocation'
    WAREHOUSE_ORG_FIELD = 'logisticsWorktype'

else:
    BUY_QUEUE = 'BUY'
    DCBUY_QUEUE = 'DCBUY'
    ACC_QUEUE = 'ACC'
    SCS_QUEUE = 'SCS'
    LDM_QUEUE = 'LDM'
    WAREHOUSE_QUEUE = 'LOGIC'
    WAREHOUSE_LOC_FIELD = 'logisticLocation'
    WAREHOUSE_ORG_FIELD = 'logisticOrganization'


# ------------------------------------------------------------------------------
# SCS


SCS_FIELDS = {
    'proektzp': lambda x: x['project']['key'],
    'zadacaPoProektuzp': lambda x: x['task']['key'],
    'price': lambda x: x['products'][0]['price'],
    'qty': lambda x: x['products'][0]['qty'],
    'geografiaMVP': lambda x: x['mvp']['key'],
    'budgetOwner': lambda x: x['cfo']['key'],
    'oe': lambda x: x['legal_entity']['shortname'],
    'zakupocnaaKategoria': lambda x: x['purchase_group']['name'],
    'servisZP': lambda x: f"{x['service']['key']}",
    'valutaZP': lambda x: x['products'][0]['currency']['char_code'],
}


# ------------------------------------------------------------------------------
# OEBS

if IS_PRODUCTION:
    OEBS_API_PREFIX = 'https://api.oebs.yandex.net/oebsapi/rest'

elif IS_TESTING:
    OEBS_API_PREFIX = 'https://oebs-api-test.ps-oebs.yandex.net/oebsapi/rest'

elif IS_DEVELOPMENT:
    OEBS_API_PREFIX = 'https://oebs-api-dev.ps-oebs.yandex.net/oebsapi/rest'


OEBS_PARAMS = {
    'verify': '/etc/ssl/certs/ca-certificates.crt',
    'headers': {'Authorization': f'OAuth {INTRANET_OAUTH_TOKEN}'},
}
