# coding: utf-8

import os

from . import ds, IS_PRODUCTION

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

LOCALE_PATHS = (os.path.join(BASE_DIR, 'locale'),)

SECRET_KEY = ds.secret_key

ALLOWED_HOSTS = ['*']

APPEND_SLASH = False

TIME_ZONE = 'Europe/Moscow'
USE_TZ = True

STATIC_URL = '/static/'
STATIC_ROOT = os.path.join(BASE_DIR, 'static')

ROOT_URLCONF = 'procu.urls'

WSGI_APPLICATION = 'procu.wsgi.application'


SWITCH_MAINTENANCE = 'procu::maintenance'
SWITCH_READONLY = 'procu::readonly'


INSTALLED_APPS = [
    # Procu
    'procu.api',
    'procu.wf',
    # Yandex
    'django_yauth',
    'django_idm_api',
    'django_pgaas',
    'django_tanker',
    # Others
    'rest_framework',
    'django_filters',
    'storages',
    'djcelery_email',
    'reversion',
    # Django
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.staticfiles',
]


MIDDLEWARE = [
    'django_replicated.middleware.ReplicationMiddleware',
    'procu.api.middleware.LogRequestContextMiddleware',
    'procu.api.middleware.ExceptionHandler',
    'procu.api.middleware.DowntimeMiddleware',
    'django_idm_api.middleware.TVMMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'procu.api.middleware.MixedAuthenticatonMiddleware',
    'procu.api.middleware.LocaleMiddleware',
    # Django
    'django.middleware.csrf.CsrfViewMiddleware',
    'procu.api.middleware.PathPermissionMiddleware',
]

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': False,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.i18n',
                'django.template.context_processors.static',
                'django.template.context_processors.tz',
            ],
            'loaders': [
                (
                    'django.template.loaders.cached.Loader',
                    ['django.template.loaders.app_directories.Loader'],
                )
            ],
        },
    }
]


# Use overriden json serialiser for `dumpdata` to preserve unicode characters
SERIALIZATION_MODULES = {'json': 'procu.utils.dump_json'}
