# coding: utf-8

# noinspection PyUnresolvedReferences
from django_yauth.settings import *

from . import IS_DEVELOPMENT, IS_PRODUCTION, ds

CSRF_COOKIE_HTTPONLY = True
CSRF_COOKIE_SECURE = True

SESSION_COOKIE_HTTPONLY = True
SESSION_COOKIE_SECURE = True

# ------------------------------------------------------------------------------

AUTH_USER_MODEL = 'api.User'

AUTHENTICATION_BACKENDS = [
    'procu.api.auth.TVMAuthBackend',
    'procu.api.auth.OAuthAuthBackend',
    'procu.api.auth.CookieAuthBackend',
    'procu.api.auth.CapabilityURLBackend',
    'procu.api.auth.ExternalAuthBackend',
]

# ------------------------------------------------------------------------------

SESSION_KEY_EMAIL = 'procu_email'

URL_PARAM_REF = 'ref'
URL_PARAM_AUTH = 'utoken'

if IS_PRODUCTION:
    URL_AUTH_EXPIRE_IN = 5  # minutes
else:
    URL_AUTH_EXPIRE_IN = 1000  # minutes

# ------------------------------------------------------------------------------

YAUTH_TYPE = 'intranet'

YAUTH_USE_SITES = False

YAUTH_PASSPORT_FIELDS = (
    ('accounts.login.uid', 'username'),
    ('userinfo.firstname.uid', 'first_name'),
    ('userinfo.lastname.uid', 'last_name'),
    ('userinfo.lang.uid', 'language'),
    ('userinfo.sex.uid', 'sex'),
)

TVM_CLIENT_ID = 2001223 if IS_PRODUCTION else 2001225
YAUTH_TVM2_CLIENT_ID = TVM_CLIENT_ID
YAUTH_TVM2_SECRET = TVM_SECRET = ds.tvm_secret
YAUTH_USE_TVM2_FOR_BLACKBOX = True

if IS_PRODUCTION:
    TVM_DOCVIEWER_CLIENT_ID = 167
    TVM_IDM_CLIENT_ID = 2001600
    TVM_ISEARCH_CLIENT_ID = 2001043
    TVM_MAGICLINKS_CLIENT_ID = 2000265
    TVM_STAFF_API_CLIENT_ID = 2001974
    TVM_TRACKER_CLIENT_ID = 176
else:
    TVM_DOCVIEWER_CLIENT_ID = 2000064
    TVM_IDM_CLIENT_ID = 2001602
    TVM_ISEARCH_CLIENT_ID = 2001037
    TVM_MAGICLINKS_CLIENT_ID = 2000266
    TVM_STAFF_API_CLIENT_ID = 2001976
    TVM_TRACKER_CLIENT_ID = 177

YAUTH_TVM2_ALLOWED_CLIENT_IDS = [
    TVM_CLIENT_ID,
    TVM_DOCVIEWER_CLIENT_ID,
    TVM_IDM_CLIENT_ID,
    TVM_MAGICLINKS_CLIENT_ID,
]

TVM_DESTINATIONS = [
    TVM_CLIENT_ID,
    TVM_ISEARCH_CLIENT_ID,
    TVM_STAFF_API_CLIENT_ID,
    TVM_TRACKER_CLIENT_ID,
]

# ------------------------------------------------------------------------------

if IS_DEVELOPMENT:
    import blackbox

    class BlackBox(blackbox.XmlBlackbox):
        def __init__(self, **kwargs):
            kwargs.pop('url', None)
            kwargs.pop('dbfields', None)
            super().__init__(url='http://blackbox', **kwargs)

    YAUTH_BLACKBOX_INSTANCE = BlackBox()
