# coding: utf-8

import logging
import os

import cssutils

from . import IS_PRODUCTION

CELERY_EMAIL_CHUNK_SIZE = 20

EMAIL_BACKEND = 'djcelery_email.backends.CeleryEmailBackend'
EMAIL_HOST = 'outbound-relay.yandex.net'
EMAIL_PORT = 25

if IS_PRODUCTION:
    EMAIL_ROBOT = 'robot-procu@yandex-team.ru'
else:
    EMAIL_ROBOT = 'robot-procu-test@yandex-team.ru'

EMAIL_MAILING_LIST = 'source@yandex-team.ru'

# If enabled, send all emails to EMAIL_MOCK_COLLECTOR
# with original recipients appended to the message body.
EMAIL_MOCK = os.getenv('PROCU_EMAIL_MOCK') == '1'
EMAIL_MOCK_COLLECTOR = 'procu-test@yandex-team.ru'

# ------------------------------------------------------------------------------

PREMAILER_CONFIG = {'remove_classes': True}

cssutils.log.setLevel(logging.ERROR)
