# coding: utf-8

from . import IS_PRODUCTION, IS_TESTING, ds

DEFAULT_FILE_STORAGE = 'procu.api.storage.S3Boto3Storage'

if IS_PRODUCTION:
    AWS_S3_ENDPOINT_URL = 'https://s3.mds.yandex.net'
    AWS_S3_USE_INTERNAL_CERT = False
    AWS_S3_URL_PROTOCOL = 'http:'

elif IS_TESTING:
    AWS_S3_ENDPOINT_URL = 'https://s3.mdst.yandex.net'
    AWS_S3_USE_INTERNAL_CERT = True
    AWS_S3_URL_PROTOCOL = 'http:'

else:
    AWS_S3_ENDPOINT_URL = 'http://s3:5000'
    AWS_S3_USE_INTERNAL_CERT = False
    AWS_S3_URL_PROTOCOL = 'http:'
    AWS_S3_ENCRYPTION = True


AWS_S3_REGION_NAME = ds.AWS_S3_REGION_NAME
AWS_ACCESS_KEY_ID = ds.AWS_ACCESS_KEY_ID
AWS_SECRET_ACCESS_KEY = ds.AWS_SECRET_ACCESS_KEY
AWS_STORAGE_BUCKET_NAME = ds.AWS_STORAGE_BUCKET_NAME

AWS_S3_FILE_OVERWRITE = False
AWS_QUERYSTRING_AUTH = False
AWS_LOCATION = 'attachments/'


PREVIEWABLE_FILE_TYPES = [
    'jpg',
    'jpeg',
    'gif',
    'png',
    'bmp',
    'pdf',
    'doc',
    'docx',
    'ppt',
    'pptx',
    'xls',
    'xlsx',
    'odt',
    'ods',
    'rtf',
    'swf',
]


if IS_PRODUCTION:
    DOCVIEWER_HOST = 'https://docviewer.yandex-team.ru'

else:
    DOCVIEWER_HOST = 'https://docviewer.tst.yandex-team.ru'
