# coding: utf-8

from datetime import timedelta

from . import IS_PRODUCTION, REDIS_HOST, REDIS_PASSWORD, REDIS_PORT

CELERY_BROKER_URL = f'redis://:{REDIS_PASSWORD}@{REDIS_HOST}:{REDIS_PORT}/2'

CELERY_TASK_IGNORE_RESULT = True

CELERY_WORKER_HIJACK_ROOT_LOGGER = False

CELERY_BEAT_SCHEDULE = {
    'update_exchange_rates': {
        'task': 'procu.api.tasks.update_exchange_rates',
        'schedule': timedelta(hours=6),
    },
    'switch_to_review': {
        'task': 'procu.api.tasks.switch_to_review',
        'schedule': timedelta(minutes=1),
    },
    'fix_formatting': {
        'task': 'procu.api.tasks.fix_formatting',
        'schedule': timedelta(minutes=15),
    },
    'update_savings_normal': {
        'task': 'procu.api.tasks.update_savings_task',
        'schedule': (
            timedelta(minutes=10) if IS_PRODUCTION else timedelta(minutes=2)
        ),
        'kwargs': {'force': False},
    },
    'update_savings_all': {
        'task': 'procu.api.tasks.update_savings_task',
        'schedule': timedelta(hours=24),
        'kwargs': {'force': True},
    },
    'make_enquiry_log': {
        'task': 'procu.api.tasks.make_enquiry_log',
        'schedule': timedelta(minutes=1),
    },
    'update_filter_idx': {
        'task': 'procu.api.tasks.update_filter_idx',
        'schedule': timedelta(minutes=5),
    },
    'fetch_buy': {
        'task': 'procu.api.tasks.fetch_buy',
        'schedule': timedelta(hours=6),
    },
}

# Это используется только для ручки api/monitoring/stats
# А это ручка сейчас никем не дергается
CELERY_REDIS = {
    'host': REDIS_HOST,
    'port': 6379,
    'db': 2,
    'password': REDIS_PASSWORD,
    'socket_timeout': 2,
}
