# coding: utf-8

from collections import OrderedDict

_ALLOW_ANY = ('create', 'retrieve', 'update', 'delete', 'list')

_ALLOW_READ = ('retrieve', 'list')

PERM_DISPLAY_NAMES = OrderedDict(
    [
        (_ALLOW_ANY, '!!(зел)полный доступ!!'),
        ('create', 'создание'),
        ('retrieve', 'чтение'),
        ('update', 'редактирование'),
        ('delete', 'удаление'),
        ('list', 'просмотр списка'),
        (
            'all',
            '(?все запросы==Где пользователь не является автором, '
            'исполнителем, или наблюдателем?)',
        ),
        ('checkout', 'запрос счёта'),
        ('progress', 'изменение статуса'),
        ('summary', 'просмотр свода в любое время'),
        ('summary_final', 'просмотр свода после сорсинга'),
    ]
)


MODEL_DISPLAY_NAMES = OrderedDict(
    [
        ('address', 'Справочник адресов'),
        ('currency', 'Справочник валют'),
        ('legalentity', 'Справочник юрлиц'),
        ('supplier', 'Справочник поставщиков'),
        ('suppliertag', 'Справочник тегов поставщиков'),
        ('user', 'Справочник контактов'),
        ('unit', 'Справочник единиц'),
        ('discount', 'Справочник дисконтов'),
        ('enquiry', 'Закупка'),
        ('enquiryproduct', 'Запрошенный товар'),
        (
            'quote',
            '(?Поставщик в закупке==Данные связанные с участием поставщика '
            'в конкретной закупке: индивидуальный дедлайн, условия оплаты, '
            'и т.п.?)',
        ),
        ('quoteproduct', 'Предложенный товар'),
        ('quotecomment', 'Комментарий к преложению'),
        ('enquirycomment', 'Комментарий к запросу'),
        ('attachment', 'Вложение'),
        ('log', 'Событие в таймлайне'),
    ]
)


ROLES_HOOKS = 'procu.idm.hooks.Hooks'

ROLES = OrderedDict(
    [
        (
            'group-admin',
            {
                'permissions': (
                    ('address', _ALLOW_ANY),
                    ('currency', _ALLOW_ANY),
                    ('legalentity', _ALLOW_ANY),
                    ('supplier', _ALLOW_ANY),
                    ('supplierwarning', _ALLOW_ANY),
                    ('suppliertag', _ALLOW_ANY),
                    ('enquirycategory', _ALLOW_ANY),
                    ('unit', _ALLOW_ANY),
                    ('discount', _ALLOW_ANY),
                    ('enquiryaccess', _ALLOW_ANY),
                    (
                        'enquiry',
                        (
                            'create',
                            'retrieve',
                            'update',
                            'list',
                            'checkout',
                            'all',
                            'progress',
                            'summary',
                        ),
                    ),
                    ('request', _ALLOW_ANY),
                    ('enquiryproduct', _ALLOW_ANY),
                    ('invoice', _ALLOW_ANY),
                    ('invoiceproduct', _ALLOW_ANY),
                    ('quote', _ALLOW_ANY),
                    ('quoteproduct', _ALLOW_ANY),
                    ('quotecomment', _ALLOW_ANY),
                    ('enquirycomment', _ALLOW_ANY),
                    ('link', _ALLOW_ANY),
                    ('attachment', ('create', 'retrieve')),
                    ('user', _ALLOW_ANY),
                    ('log', ('list',)),
                ),
                'meta': {
                    'name': {'ru': 'Администратор', 'en': 'Administrator'}
                },
            },
        ),
        # ('group-auditor', {
        #     'permissions': (
        #         ('address', _ALLOW_READ),
        #         ('currency', _ALLOW_READ),
        #         ('legalentity', _ALLOW_READ),
        #         ('supplier', _ALLOW_READ),
        #         ('suppliertag', _ALLOW_READ),
        #         ('enquirycategory', _ALLOW_READ),
        #         ('unit', _ALLOW_READ),
        #         ('discount', _ALLOW_READ),
        #
        #         ('enquiryaccess', _ALLOW_READ),
        #         ('enquiry', ('retrieve', 'list', 'all', 'summary')),
        #         ('enquiryproduct', _ALLOW_READ),
        #         ('invoice', _ALLOW_READ),
        #         ('invoiceproduct', _ALLOW_READ),
        #
        #         ('quote', _ALLOW_READ),
        #         ('quoteproduct', _ALLOW_READ),
        #         ('quotecomment', _ALLOW_READ),
        #         ('enquirycomment', _ALLOW_READ),
        #         ('link', _ALLOW_READ),
        #
        #         ('attachment', ('create', 'retrieve', )),
        #
        #         ('user', _ALLOW_READ),
        #         ('log', ('list', )),
        #     ),
        #
        #     'meta': {
        #         'name': {
        #             'ru': 'Аудитор',
        #             'en': 'Auditor',
        #         },
        #     },
        # }),
        (
            'group-manager',
            {
                'permissions': (
                    ('address', _ALLOW_ANY),
                    ('currency', _ALLOW_ANY),
                    ('legalentity', _ALLOW_ANY),
                    ('supplier', _ALLOW_ANY),
                    ('supplierwarning', _ALLOW_ANY),
                    ('suppliertag', _ALLOW_ANY),
                    ('enquirycategory', _ALLOW_ANY),
                    ('unit', _ALLOW_ANY),
                    ('discount', ('list', 'retrieve')),
                    ('enquiryaccess', _ALLOW_ANY),
                    (
                        'enquiry',
                        (
                            'create',
                            'retrieve',
                            'update',
                            'list',
                            'checkout',
                            'progress',
                            'summary',
                        ),
                    ),
                    ('request', _ALLOW_ANY),
                    ('enquiryproduct', _ALLOW_ANY),
                    ('invoice', _ALLOW_ANY),
                    ('invoiceproduct', _ALLOW_ANY),
                    ('quote', _ALLOW_ANY),
                    ('quoteproduct', _ALLOW_ANY),
                    ('quotecomment', _ALLOW_ANY),
                    ('enquirycomment', _ALLOW_ANY),
                    ('link', _ALLOW_ANY),
                    ('attachment', ('create', 'retrieve')),
                    ('user', _ALLOW_ANY),
                    ('log', ('list',)),
                ),
                'meta': {
                    'name': {
                        'ru': 'Менеджер закупок',
                        'en': 'Procurement Manager',
                    }
                },
            },
        ),
        (
            'group-budgetholder',
            {
                'permissions': (
                    # Allow GET requests to show pop-up info on the enquiry page
                    ('address', ('retrieve',)),
                    ('currency', ()),
                    ('legalentity', ()),
                    ('supplier', ('retrieve',)),
                    ('supplierwarning', ()),
                    ('suppliertag', ()),
                    ('enquirycategory', ()),
                    ('enquiryaccess', ('list',)),
                    (
                        'enquiry',
                        (
                            'create',
                            'retrieve',
                            'update',
                            'list',
                            'summary_final',
                            'summary',
                        ),
                    ),
                    ('request', ('retrieve',)),
                    ('enquiryproduct', _ALLOW_ANY),
                    ('link', _ALLOW_ANY),
                    ('invoice', ('list', 'retrieve')),
                    ('invoiceproduct', ('list', 'retrieve')),
                    ('quote', ('list', 'retrieve')),
                    ('quoteproduct', ('list',)),
                    ('quotecomment', _ALLOW_ANY),
                    ('enquirycomment', _ALLOW_ANY),
                    ('attachment', ('create', 'retrieve')),
                    ('user', ()),
                    ('log', ()),
                ),
                'meta': {
                    'name': {'ru': 'Держатель бюджета', 'en': 'Budget Holder'}
                },
            },
        ),
        (
            'group-customer',
            {
                'permissions': (
                    # Allow GET requests to show pop-up info on the enquiry page
                    ('address', ('retrieve',)),
                    ('currency', ()),
                    ('legalentity', ()),
                    ('supplier', ()),
                    ('supplierwarning', ()),
                    ('suppliertag', ()),
                    ('enquirycategory', ()),
                    ('enquiryaccess', ('list',)),
                    (
                        'enquiry',
                        ('create', 'retrieve', 'update', 'list', 'summary'),
                    ),
                    ('request', ('retrieve',)),
                    ('enquiryproduct', _ALLOW_ANY),
                    ('invoice', ('list', 'retrieve')),
                    ('invoiceproduct', ('list', 'retrieve')),
                    ('quote', ('list', 'retrieve')),
                    ('quoteproduct', ('list',)),
                    ('quotecomment', _ALLOW_ANY),
                    ('enquirycomment', _ALLOW_ANY),
                    ('link', _ALLOW_ANY),
                    ('attachment', ('create', 'retrieve')),
                    ('user', ()),
                    ('log', ()),
                ),
                'meta': {'name': {'ru': 'Заказчик', 'en': 'Customer'}},
            },
        ),
        (
            'group-logistician',
            {
                'permissions': (
                    ('address', ('retrieve', 'update', 'list')),
                    ('currency', ()),
                    ('legalentity', ()),
                    ('supplier', ()),
                    ('supplierwarning', ()),
                    ('suppliertag', ()),
                    ('enquirycategory', ()),
                    ('enquiryaccess', ('list',)),
                    ('enquiry', ('retrieve', 'update', 'list')),
                    ('request', ('retrieve',)),
                    ('enquiryproduct', _ALLOW_ANY),
                    ('quote', ('list', 'retrieve')),
                    ('quoteproduct', ('list',)),
                    ('quotecomment', _ALLOW_ANY),
                    ('enquirycomment', _ALLOW_ANY),
                    ('link', _ALLOW_ANY),
                    ('invoice', ('list', 'retrieve')),
                    ('invoiceproduct', ('list', 'retrieve')),
                    ('attachment', ('create', 'retrieve')),
                    ('user', ()),
                    ('log', ()),
                ),
                'meta': {
                    'name': {'ru': 'Логист', 'en': 'Logistics Specialist'}
                },
            },
        ),
        (
            'group-employee',
            {
                'permissions': (
                    # Allow GET requests to show pop-up info on the enquiry page
                    ('address', ('retrieve',)),
                    ('currency', ()),
                    ('legalentity', ()),
                    ('supplier', ()),
                    ('supplierwarning', ()),
                    ('suppliertag', ()),
                    ('enquirycategory', ()),
                    ('enquiryaccess', ('list',)),
                    ('enquiry', ('create', 'retrieve', 'update', 'list')),
                    ('request', ()),
                    ('enquiryproduct', _ALLOW_ANY),
                    ('quote', ('list', 'retrieve')),
                    ('quoteproduct', ('list',)),
                    ('quotecomment', _ALLOW_ANY),
                    ('enquirycomment', _ALLOW_ANY),
                    ('link', _ALLOW_ANY),
                    ('invoice', ('list', 'retrieve')),
                    ('invoiceproduct', ('list', 'retrieve')),
                    ('attachment', ('create', 'retrieve')),
                    ('user', ()),
                    ('log', ()),
                ),
                'meta': {'name': {'ru': 'Сотрудник', 'en': 'Staff Member'}},
            },
        ),
        (
            'group-agent',
            {
                'permissions': (
                    ('address', ()),
                    ('currency', ()),
                    ('legalentity', ()),
                    ('supplier', ()),
                    ('supplierwarning', ()),
                    ('suppliertag', ()),
                    ('enquirycategory', ()),
                    ('enquiry', ('retrieve',)),
                    ('enquiryproduct', ()),
                    ('invoice', ('list', 'retrieve')),
                    ('invoiceproduct', ('list', 'update', 'retrieve')),
                    ('quote', ('list', 'retrieve', 'update')),
                    ('quotecomment', _ALLOW_ANY),
                    ('quoteproduct', _ALLOW_ANY),
                    ('enquirycomment', ()),
                    ('attachment', ('create', 'retrieve')),
                    ('user', ()),
                    ('log', ()),
                ),
                'meta': {
                    'name': {'ru': 'Поставщик', 'en': 'Supplier'},
                    'visibility': False,
                },
            },
        ),
    ]
)
