# coding: utf-8

from copy import deepcopy

# ------------------------------------------------------------------------------

CSP_ALLOWED_POLICIES = {
    'base-uri',
    'block-all-mixed-content',
    'child-src',
    'connect-src',
    'default-src',
    'disown-opener',
    'font-src',
    'form-action',
    'frame-ancestors',
    'frame-src',
    'img-src',
    'manifest-src',
    'media-src',
    'object-src',
    'plugin-types',
    'referrer',
    'reflected-xss',
    'report-uri',
    'sandbox',
    'script-src',
    'strict-dynamic',
    'style-src',
    'upgrade-insecure-requests',
    'worker-src',
}

# ------------------------------------------------------------------------------

CSP_POLICIES_EXTERNAL = {
    'default-src': ["'none'"],
    'object-src': ["'self'"],
    'script-src': [
        "'self'",
        'mc.yandex.ru',
        "'unsafe-eval'",
        "'unsafe-inline'",
        "'nonce-{nonce}'",
        'yastatic.net',
        'l7test.yastatic.net',
        'pass.yandex.ru',
        'export.yandex.ru',
        '*.yandex.net',
        'https://api-maps.yandex.ru',
        'https://suggest-maps.yandex.ru',
        'https://*.maps.yandex.net',
        'https://yandex.ru',
    ],
    'style-src': [
        "'self'",
        "'unsafe-inline'",
        'yastatic.net',
        'l7test.yastatic.net',
        'mc.yandex.ru',
        'blob:',
    ],
    'font-src': ["'self'", 'yastatic.net', 'l7test.yastatic.net'],
    'img-src': [
        "'self'",
        'data:',
        'https://*.maps.yandex.net',
        'api-maps.yandex.ru',
        'yapic.yandex.ru',
        'avatars.mds.yandex.net',
        'mc.yandex.ru',
        'yastatic.net',
        'l7test.yastatic.net',
        'yapic-test.yandex.ru',
        'avatars.mdst.yandex.net',
    ],
    'frame-src': [
        "'self'",
        'https://api-maps.yandex.ru',
        'https://yamb.yandex-team.ru',
    ],
    'child-src': ["'self'", 'https://api-maps.yandex.ru'],
    'connect-src': ["'self'", 'mc.yandex.ru'],
}

# ------------------------------------------------------------------------------
# Keep separate list of policies to avoid exposing internal hostnames

CSP_POLICIES_INTERNAL = _csp_int = deepcopy(CSP_POLICIES_EXTERNAL)

_csp_int['script-src'].append('*.yandex-team.ru')
_csp_int['img-src'].append('*.yandex-team.ru')

_csp_int['connect-src'].extend(('*.yandex-team.ru', 'nda.ya.ru'))

_csp_int['frame-src'].extend(
    (
        'st.yandex-team.ru',
        'st.test.yandex-team.ru',
        'https://gcn.yandex-team.ru',
    )
)

# ------------------------------------------------------------------------------

CSP_SERVICE_NAME = 'procu-www'
CSP_REPORT_URI = 'https://csp.yandex.net/csp'
