# coding: utf-8

from hashlib import md5
from . import REDIS_HOST, REDIS_PORT, REDIS_PASSWORD


def key_func(key, key_prefix, version):

    if isinstance(key, tuple):
        key = md5(':'.join(map(str, key)).encode()).hexdigest()

    return f'{key_prefix}:{version}:{key}'


CACHES = {
    'default': {
        'BACKEND': 'django_redis.cache.RedisCache',
        'LOCATION': f'redis://{REDIS_HOST}:{REDIS_PORT}/10',
        'OPTIONS': {
            'CLIENT_CLASS': 'django_redis.client.DefaultClient',
            'PASSWORD': REDIS_PASSWORD,
            'SOCKET_CONNECT_TIMEOUT': 2,  # sec
            'SOCKET_TIMEOUT': 2,  # sec
            'IGNORE_EXCEPTIONS': True,
            'MAX_ENTRIES': 2000,
        },
        'KEY_PREFIX': 'procu',
        'KEY_FUNCTION': key_func,
        'TIMEOUT': None,  # never expire by default
        'VERSION': 1,
    }
}

DJANGO_REDIS_LOG_IGNORED_EXCEPTIONS = True
