# coding: utf-8

from datetime import timedelta

from procu.api.enums import LINK
from . import IS_PRODUCTION

if IS_PRODUCTION:
    LINK_URLS = {
        LINK.PROCU: 'https://procu.yandex-team.ru/{key}',
        LINK.TRACKER: 'https://st.yandex-team.ru/{key}',
    }

    LINK_FAVICONS = {
        LINK.PROCU: 'https://procu.yandex-team.ru/favicon.ico',
        LINK.TRACKER: 'https://st.yandex-team.ru/favicon.ico',
    }

else:
    LINK_URLS = {
        LINK.PROCU: 'https://procu.test.yandex-team.ru/{key}',
        LINK.TRACKER: 'https://st.test.yandex-team.ru/{key}',
    }

    LINK_FAVICONS = {
        LINK.PROCU: 'https://procu.test.yandex-team.ru/favicon.ico',
        LINK.TRACKER: 'https://st.test.yandex-team.ru/favicon__testing.ico',
    }

LINK_TRACKER_CACHE_TIME = timedelta(hours=1)
