# coding: utf-8
import os
from importlib import import_module
from pkgutil import iter_modules

import datasources_config_wrapper
import yenv

ds = datasources_config_wrapper.DatasourcesConfigWrapper(
    prefix='procu',
    suppress_warning=True,
    local_datasources_path='/etc/yandex/tools-datasources/datasources-local.py',
    fallback_on_env_vars=True,
)


settings_dir = os.path.dirname(os.path.abspath(__file__))


def ref(setting_name):
    return globals()[setting_name]


IS_DEVELOPMENT = yenv.type == 'development'
IS_TESTING = yenv.type == 'testing'
IS_PRODUCTION = yenv.type == 'production'


REDIS_HOST = os.environ.get('REDIS_HOST', '')
REDIS_PORT = os.environ.get('REDIS_PORT', 6379)
REDIS_PASSWORD = os.environ.get('REDIS_PASSWORD')


for loader, name, ispkg in iter_modules([settings_dir]):
    m = import_module('.%s' % name, package='procu.settings')
    globals().update(m.__dict__)
