# coding: utf-8

from django.db.transaction import non_atomic_requests as _n
from django.urls import include, path, re_path

from procu.api.error import views as error
from procu.api.html.views import main, products


def _include(_path):
    return include('procu.api.%s' % _path)


urlpatterns = [
    re_path(
        r'^api/',
        include(
            [
                path('suggests', _include('suggests.urls')),
                path('supplier_tags', _include('supplier_tag.urls')),
                path('currencies', _include('currency.urls')),
                path('addresses', _include('address.urls')),
                path('legal_entities', _include('legal_entity.urls')),
                path('suppliers', _include('supplier.urls')),
                path('categories', _include('category.urls')),
                path('contacts', _include('contact.urls')),
                path('units', _include('unit.urls')),
                path('discounts', _include('discount.urls')),
                path('users', _include('user.urls')),
                path('requests', _include('request.urls')),
                path('enquiries', _include('enquiry.urls')),
                path('products', _include('product.urls')),
                path('savings', _include('saving.urls')),
                path('timeline', _include('log.urls')),
                path('attachments', _include('attachment.urls')),
                path('tracker', _include('tracker.urls')),
                path('wiki', _include('wiki.urls')),
                path('misc', _include('misc.urls')),
                path('monitoring', _include('monitoring.urls')),
                path('reply', _include('reply.urls')),
                path('dashboards', _include('dashboard.urls')),
                path('spark', _include('spark.urls')),
                path('account', _include('account.urls')),
                path('oebs', _include('oebs.urls')),
                re_path(r'.+', error.error_404),
            ]
        ),
    ),
    path('idm/', include('django_idm_api.urls')),
    re_path(r'^local/products2/?.*', _n(products), kwargs={'prefix': 'local'}),
    re_path(r'^local/?.*', _n(main), kwargs={'prefix': 'local'}),
    re_path(r'^products2/?.*', _n(products)),
    re_path(r'^/?.*', _n(main)),
]

handler404 = error.error_404
handler500 = error.error_500
