# coding: utf-8

from django.core.serializers.json import (
    Serializer as BaseSerializer,
    Deserializer,  # Required for dumpdata
)


class Serializer(BaseSerializer):
    """
    Override default json serialiser to preserve unicode characters
    """

    def _init_options(self):
        super()._init_options()
        self.json_kwargs['ensure_ascii'] = False
