# coding: utf-8
import os


def setup_environ():
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'procu.settings')

    os.environ['YENV_NAME'] = 'intranet'

    # Импортируем celery app, чтобы инициализировалось приложение
    # noinspection PyUnresolvedReferences
    from procu.celery import app


def manage():
    setup_environ()

    from django.core.management import execute_from_command_line

    return execute_from_command_line()


def manage_celery():
    setup_environ()

    from celery.__main__ import main

    return main()


if __name__ == '__main__':
    manage()
